from django import template

register = template.Library()

@register.filter
def get_rating_stars(rating):
    full_stars = int(rating)
    half_stars = 1 if rating - full_stars >= 0.5 else 0
    empty_stars = 5 - full_stars - half_stars
    return {'full_stars': range(full_stars),
            'half_stars': half_stars,
            'empty_stars': range(empty_stars)}
