from django import forms
from .models import *
from apps.helpers import *

class BrandForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field in self.fields.items():

            if isinstance(field, forms.ImageField):
                field.widget.attrs.update({'class': 'img-class'})  
            if isinstance(field, forms.ChoiceField): 
                field.widget.attrs.update({'class': 'choice-class'})

    class Meta:
        model = Brand
        fields = '__all__'

class CategoryForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field in self.fields.items():

            if isinstance(field, forms.ImageField):
                field.widget.attrs.update({'class': 'img-class'})  
            if isinstance(field, forms.ChoiceField): 
                field.widget.attrs.update({'class': 'choice-class'})
  
    class Meta:
        model = Category
        fields = '__all__'

class ProductForm(CustomFieldMixin,forms.ModelForm):



    class Meta:
        model = Product
        fields = '__all__'
        exclude = ['additional_info', 'variations', 'slug'] 
        widgets = {
            'details': forms.Textarea(attrs={'class': 'ckeditor-class', 'required': False}),
            'color': forms.TextInput(attrs={'placeholder': 'Enter colors separated by commas'}),
            'size': forms.TextInput(attrs={'placeholder': 'Enter sizes separated by commas'}),

        }

        help_texts = {
            'color': 'Enter colors separated by commas (e.g., red, blue, green)',
            'size': 'Enter sizes separated by commas (e.g., sm, md, xl, xxl)',

        }



class ProductReviewForm(forms.ModelForm):
    class Meta:
        model = ProductReview
        fields = '__all__'
