# Generated by Django 4.2.10 on 2024-03-17 10:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Brand',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('img', models.ImageField(blank=True, null=True, upload_to='brand_images/')),
                ('details', models.TextField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('img', models.ImageField(upload_to='category_images/')),
                ('details', models.TextField(null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('slug', models.SlugField(blank=True, max_length=100, unique=True)),
                ('short_details', models.TextField(max_length=500)),
                ('sku', models.CharField(blank=True, max_length=200, null=True)),
                ('points', models.IntegerField(default=0)),
                ('price', models.DecimalField(decimal_places=2, max_digits=10)),
                ('discount', models.BooleanField(blank=True, default=False, null=True)),
                ('previous_price', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('image', models.ImageField(upload_to='product_images/')),
                ('stock_count', models.IntegerField(default=0)),
                ('rating', models.FloatField(default=4.5)),
                ('remark', models.CharField(choices=[('popular', 'Popular'), ('new', 'New'), ('top', 'Top'), ('special', 'Special'), ('trending', 'Trending'), ('regular', 'Regular')], default='regular', max_length=10)),
                ('details', models.TextField(blank=True, null=True)),
                ('img1', models.ImageField(blank=True, null=True, upload_to='product_images/')),
                ('img2', models.ImageField(blank=True, null=True, upload_to='product_images/')),
                ('img3', models.ImageField(blank=True, null=True, upload_to='product_images/')),
                ('img4', models.ImageField(blank=True, null=True, upload_to='product_images/')),
                ('color', models.CharField(blank=True, max_length=255, null=True)),
                ('size', models.CharField(blank=True, max_length=255, null=True)),
                ('is_active', models.BooleanField(blank=True, default=True, null=True)),
                ('is_reseller', models.BooleanField(blank=True, default=False, null=True)),
                ('reseller_price', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=10, null=True)),
                ('variations', models.TextField(blank=True, null=True)),
                ('additional_info', models.TextField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('brand', models.ForeignKey(null=True, on_delete=django.db.models.deletion.RESTRICT, to='products.brand')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.RESTRICT, to='products.category')),
            ],
        ),
        migrations.CreateModel(
            name='PromoCode',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(help_text='Unique promo code', max_length=20, unique=True)),
                ('discount_percent', models.DecimalField(decimal_places=2, help_text='Discount percentage', max_digits=5)),
                ('expiration_date', models.DateField(help_text='Expiration date of the promo code')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, help_text='Date and time when the promo code was created')),
                ('is_active', models.BooleanField(default=True, help_text='Is the promo code currently active')),
            ],
        ),
        migrations.CreateModel(
            name='ProductReview',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('details', models.CharField(max_length=1000)),
                ('rating', models.CharField(max_length=10)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('customer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.RESTRICT, to=settings.AUTH_USER_MODEL)),
                ('product', models.ForeignKey(null=True, on_delete=django.db.models.deletion.RESTRICT, to='products.product')),
            ],
        ),
    ]
